# 확장 2
농장이 다시 확장되었어요! 이제 타일들이 더 이상 예쁘게 한 줄로 있지 않아서, 정사각형 격자를 순회하는 방법을 찾아야 해요.

`while` 루프로는 감각과 연산자를 해금하기 전까지는 불가능해요.
이제 `for` 루프를 소개할 시간이에요.

`for` 루프에 대한 모든 것은 [For 루프](docs/scripting/for.md) 페이지에서 읽을 수 있지만, 지금은 코드를 정해진 횟수만큼 반복하는 데만 필요할 거예요.

`#n번 재주넘기
for i in range(5):
	do_a_flip()`

`range(n)`은 `0`부터 `n-1`까지 `n`개의 요소를 가진 숫자 범위를 만들어요. `for` 루프는 시퀀스의 모든 요소에 대해 루프 본문을 한 번씩 실행해요. 이 예시에서 `do_a_flip()`은 `5`번 호출될 거예요.

`get_world_size()` 함수도 이제 사용할 수 있어요. 농장의 한 변 길이를 반환해요. 이렇게 하면 다음 확장 업그레이드에도 망가지지 않는 코드를 작성할 수 있어요.

`for i in range(get_world_size()):
	harvest()
	move(North)`

이 예시는 어떤 농장 크기에서든 농장의 한 열을 수확해요.

드론을 농장 주위로 어떻게 움직일지 알아내느라 막혔다면 아래 힌트를 보세요.
<spoiler=힌트 보기>물론, 농장을 돌아다니는 방법은 여러 가지가 있어요.
우리가 찾는 것은 농장이 다시 커져도 망가지지 않는 체계적인 순회 방법이에요.
농장의 모든 곳에 도달하는 체계적인 방법은 다음 2단계를 영원히 반복하는 것이에요:

1.다시 돌아올 때까지 `North`로 이동해요.
2.`East`로 이동해요.

`for i in range(get_world_size()):`가 이 아이디어를 코드로 바꾸는 데 도움이 될 수 있어요.
</spoiler>
<spoiler=가능한 해결책 보기> 기본 순회는 다음과 같을 수 있어요:

`for i in range(get_world_size()):
	for j in range(get_world_size()):
		#모든 타일에서 재주넘기
		do_a_flip()
		move(North)
	move(East)`
</spoiler>